;(function () {
    /**
     *
     * キーイベントプラグイン
     *
     */

    //既定イベント保存用
    TYRANO.kag.stat.f._event_set = {}

    /**
     * タグ定義
     */

    /**
     * イベント登録
     */
    TYRANO.kag.tag.event_set = {
        vital: ["name"],
        pm: {
            name: "",
            key: "Enter",
            storage: "",
            target: "",
            exp: "",
            once: "false",
            default: "true",
        },
        start(pm) {
            const that = this
            const f = TYRANO.kag.stat.f._event_set

            //登録済みの場合一旦削除
            $(document).off("keyup." + pm.name)

            //既定のイベント
            if (pm.default === "false") {
                f[pm.name] = {
                    key: pm.key,
                    action: TYRANO.kag.key_mouse.map_key[pm.key],
                }
                TYRANO.kag.key_mouse.map_key[pm.key] = ""
            }

            $(document).on("keyup." + pm.name, function (e) {
                console.log(TYRANO.kag.key_mouse.keyboard.getKeyState(e))
                const key = TYRANO.kag.key_mouse.keyboard.getKeyState(e)
                if (key.key === pm.key) {
                    e.stopPropagation()
                    e.preventDefault()

                    if (pm.once === "true") {
                        TYRANO.kag.ftag.startTag("event_delete", {
                            name: pm.name,
                            nextorder: "false",
                        })
                    }
                    if (pm.exp !== "") {
                        TYRANO.kag.evalScript(pm.exp)
                    }
                    if (pm.storage !== "" || pm.target !== "") {
                        TYRANO.kag.ftag.startTag("jump", {
                            storage: pm.storage,
                            target: pm.target,
                        })
                    }
                }
            })
            TYRANO.kag.ftag.nextOrder()
        },
    }
    TYRANO.kag.ftag.master_tag.event_set = TYRANO.kag.tag.event_set
    TYRANO.kag.ftag.master_tag.event_set.kag = TYRANO.kag

    /**
     * イベント削除
     */
    TYRANO.kag.tag.event_delete = {
        vital: ["name"],
        pm: {
            name: "",
            nextorder: "true",
        },
        start(pm) {
            const that = this
            const f = TYRANO.kag.stat.f._event_set

            $(document).off("keyup." + pm.name)

            if (f[pm.name] !== undefined) {
                TYRANO.kag.key_mouse.map_key[f[pm.name].key] = f[pm.name].action
                delete f[pm.name]
            }

            if (pm.nextorder === "true") {
                TYRANO.kag.ftag.nextOrder()
            }
        },
    }
    TYRANO.kag.ftag.master_tag.event_delete = TYRANO.kag.tag.event_delete
    TYRANO.kag.ftag.master_tag.event_delete.kag = TYRANO.kag
})()
