// Copyright 2023 TigRig All rights reserved.

// バックログの HTML を変更
TYRANO.kag.stat.sysview.backlog = "./data/others/plugin/mozibake_backlog/assets/backlog.html";

// バックログに挿入する１行分のログを生成していくタグ
// → push_accumulated_log でバックログに挿入する
tyrano.plugin.kag.tag.accumulate_log = {
    vital: ["text"],
    pm: {
        text: "",
        nazolang_id: "",
    },
    start: function (pm) {
        // 現在の accumulated log （バックログ追加前の１行分のログテキスト）を取得
        const is_nazolang = pm.nazolang_id != "";
        const accumulated_log = this.get_current_accumulated_log(is_nazolang);

        // 上記を jQuery オブジェクトに変換
        const $log_line = $(accumulated_log);

        // テキスト領域に対してログ追記を行う
        const $log_text = $log_line.find(".log_text");
        $log_text.append(this.$create_inner_element(pm.text, pm.nazolang_id));

        // メッセージ区切りの下線
        const $border = $("<p></p>").css("border-bottom", "solid 2px");

        // tmp 変数に記録
        TYRANO.kag.tmp.backlog_accumulated_log = $log_line.outerHTML() + $border.outerHTML();

        // 次の処理へ
        TYRANO.kag.ftag.nextOrder();
    },
    /**
     * 追記するログの jQuery オブジェクトを生成する
     * @param {String} text ログテキスト
     * @param {String} nazolang_id ログが謎言語の場合、その ID（解読文字に使用する）
     */
    $create_inner_element(text, nazolang_id) {
        // 通常テキストの場合、そのままテキストを帰す
        if (nazolang_id == "") return text;

        // 謎言語の場合 ↓

        // 解読文字
        const $nazolang_ruby = $("<div></div>").addClass("nazolang_ruby");
        $nazolang_ruby.attr("data", nazolang_id);
        $nazolang_ruby.text(TYRANO.kag.variable.sf[nazolang_id]);
        // 謎言語
        const $nazolang = $("<div></div>").addClass("nazolang");
        $nazolang.text(text);

        // 解読文字＋謎言語のコンテナ
        const $nazolang_word = $("<div></div>").addClass("nazolang_word");
        $nazolang_word.append($nazolang_ruby, $nazolang);

        // 「解読文字＋謎言語のコンテナ」を返す
        return $nazolang_word;
    },
    /**
     * バックログ追加前の１行分のログテキストを取得（無い場合は初期値としてログコンテナ HTML の文字列を返す）
     * @param {Boolean} is_nazolang ログテキストが謎言語であるか（初期値のコンテナ生成時に使用する）
     * @returns {String} １行分のログのテキスト（文字列形式の HTML エレメント ※jQuery オブジェクトではない）
     */
    get_current_accumulated_log(is_nazolang) {
        const accumulated_log = TYRANO.kag.tmp.backlog_accumulated_log || "";

        // 既にデータがあればそのまま返す
        if (accumulated_log !== "") return accumulated_log;

        // キャラ名領域
        const $log_chara = $("<div></div>").addClass("log_chara");
        // テキスト領域（謎言語ならば更にクラス付与する）
        const $log_text = $("<div></div>").addClass("log_text");
        if (is_nazolang) $log_text.addClass("log_nazolang");

        // １行分のログコンテナ
        const $log_line = $("<div></div>").addClass("log_line").append($log_chara, $log_text);

        // キャラ名は最初に作成してしまう
        // （本タグでテキスト部分を追記していくにあたって、キャラ名は常に同じであるため）
        const chara_name = this.get_current_chara_name();
        if (TYRANO.kag.tmp.backlog_last_chara !== chara_name) {
            TYRANO.kag.tmp.backlog_last_chara = chara_name;
            $log_chara.text(chara_name);
        }

        // １行分のログコンテナの outerHTML を返す
        return $log_line.outerHTML();
    },
    /**
     * 現在表示中のキャラ名を取得
     * @returns {String} キャラ名（見つからないときは空文字）
     */
    get_current_chara_name() {
        const chara_number = TYRANO.kag.stat.f.chara;

        // ※ 0番『モブ』だけはシステム変数でなくゲーム変数で管理されている
        if (chara_number == "0") return TYRANO.kag.stat.f.mobN || "";

        // 他はシステム変数の値を返す
        return chara_number ? TYRANO.kag.variable.sf[`C${chara_number.toString().padStart(2, "0")}`] : "";
    },
};

// バックログにログを挿入するタグ
tyrano.plugin.kag.tag.push_accumulated_log = {
    pm: {},
    start: function (pm) {
        // accumulate_log タグで生成された１行分のログをバックログデータに追記
        TYRANO.kag.pushBackLog(TYRANO.kag.tmp.backlog_accumulated_log);

        // backlog_accumulated_log はクリアする
        TYRANO.kag.tmp.backlog_accumulated_log = "";

        TYRANO.kag.ftag.nextOrder();
    },
};

//マスタータグに追加
tyrano.plugin.kag.ftag.master_tag["accumulate_log"] = object(tyrano.plugin.kag.tag["accumulate_log"]);
tyrano.plugin.kag.ftag.master_tag["accumulate_log"].kag = TYRANO.kag;
tyrano.plugin.kag.ftag.master_tag["push_accumulated_log"] = object(tyrano.plugin.kag.tag["push_accumulated_log"]);
tyrano.plugin.kag.ftag.master_tag["push_accumulated_log"].kag = TYRANO.kag;

