// Copyright 2023 TigRig All rights reserved.

(function () {
    // ※グローバル空間の変数汚染を防ぐため即時関数を使用

    // macro.ks の [WO] [WON] で翻訳 ptext の name パラメータに渡している名称
    const TARGET_CLASS = "nazolang_ruby_ptext";

    // ゲーム画面上の謎言語の解読情報（翻訳テキスト）を更新する
    $(`.${TARGET_CLASS}`).each((index, element) => {
        let id = "";
        // 設定されているクラス名に対するループ
        for (const cls of $(element).attr("class").split(" ")) {
            // 例: "nazolang_ruby_ptext_T001" → "T001" の部分を抜き出す処理
            if (!cls.includes(`${TARGET_CLASS}_`)) continue;
            id = cls.replace(`${TARGET_CLASS}_`, "");
        }
        // 翻訳テキストを更新
        $(element).text(TYRANO.kag.variable.sf[id] || "");
    });
})();

